<?php
include 'db.php'; // Database connection

header('Content-Type: application/json'); // Set header for JSON response

$response = ['status' => 'error', 'message' => 'An unexpected error occurred.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Capture and sanitize form data
    $productname = mysqli_real_escape_string($connection, $_POST['name']);
    $sale_price = mysqli_real_escape_string($connection, $_POST['sale_price']);
    $mrp = mysqli_real_escape_string($connection, $_POST['mrp']);
    $purchase_price = mysqli_real_escape_string($connection, $_POST['purchase_price']);
    $color = mysqli_real_escape_string($connection,$_POST['color']);
    $tax_included = mysqli_real_escape_string($connection, $_POST['tax_included']);
    $tax = mysqli_real_escape_string($connection, $_POST['tax']);
    $category = mysqli_real_escape_string($connection, $_POST['category']);
    $productdesc = mysqli_real_escape_string($connection, $_POST['description']);
    $quantity = mysqli_real_escape_string($connection, $_POST['quantity']); 
    $unit = mysqli_real_escape_string($connection, $_POST['unit']);
    $mode = "1"; 
    $delete_status = 0;

    // Process image
    $imagePath = null;

    if (!empty($_FILES['image']['name'])) {
        // Handle file upload
        $targetDir = "assests/images/";  
        $imageName = time() . "_" . basename($_FILES['image']['name']);
        $targetFilePath = $targetDir . $imageName;

        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0755, true);
        }

        if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFilePath)) {
            $imagePath = $targetFilePath;
        } else {
            $response['message'] = "Image upload failed.";
            echo json_encode($response);
            exit;
        }
    } elseif (!empty($_POST['image_url'])) {
        // Handle image URL
        $imageUrl = $_POST['image_url'];
        $targetDir = "assests/images/";  
        $imageName = time() . "_" . basename($imageUrl);
        $targetFilePath = $targetDir . $imageName;

        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0755, true);
        }

        if (copy($imageUrl, $targetFilePath)) {
            $imagePath = $targetFilePath;
        } else {
            $response['message'] = "Failed to download image from URL.";
            echo json_encode($response);
            exit;
        }
    }

    // Generate SKU dynamically
    $sql3 = "SELECT CONCAT('SKU-', LPAD(COUNT(id) + 1, 5, '0')) AS sku FROM product";
    $sqlexecute = mysqli_query($connection, $sql3);
    $row = mysqli_fetch_array($sqlexecute);
    $sku = $row['sku'];

    // Insert data into the database
    $sql = "INSERT INTO product (productname,colour, price, mrp, purchaseprice, taxinclu, tax, category, productdesc, qty, munit, productimage, sku, saleprice, mode, delete_status, createrid, editorid) 
            VALUES ('$productname','$color', '$sale_price', '$mrp', '$purchase_price', '$tax_included', '$tax', '$category', '$productdesc', '$quantity', '$unit', '$imagePath', '$sku', '$sale_price', '$mode', '$delete_status', 1, 1)";

    if (mysqli_query($connection, $sql)) {
        $response = ['status' => 'success', 'message' => 'Product saved successfully!'];
    } else {
        $response['message'] = "Database error: " . mysqli_error($connection);
    }

    mysqli_close($connection);
    echo json_encode($response); // Send JSON response
}
?>
